<?php

namespace Modules\Kitchen\Http\Controllers;

use App\Models\KotPlace;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class KitchenController extends Controller
{
    /**
     * Display a listing of the resource.
     */

    public function index()
    {
        abort_if(!in_array('Kitchen', restaurant_modules()), 403);

        return view('kitchen::kitchen_places.index');
    }

    public function showKot($id)
    {
        abort_if(!in_array('Kitchen', restaurant_modules()), 403);

        $kot = KotPlace::findOrFail($id);
        return view('kitchen::kitchen_places.kitchen-details', compact('kot'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('kitchen::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request) {}

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        return view('kitchen::show');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        return view('kitchen::edit');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id) {}

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id) {}
}
